(() => {
  "use strict";

  // ✅ Ya NO persistimos "cerrado" entre recargas
  // const STORAGE_KEY = "site_robot_toast_dismissed_v1";
  // if (localStorage.getItem(STORAGE_KEY) === "1") return;

  const messages = [
    "Hola 👋 Soy tu mini-robot. Si algo se ve raro, revisa primero styles.css 😉",
    "Tip: En esta landing, lo global vive en styles.css y lo específico en assets/css/index.css.",
    "¿Vas a cambiar textos? Empieza por index.html: está comentado para que lo edites fácil."
  ];

  const msg = messages[Math.floor(Math.random() * messages.length)];

  const toast = document.createElement("div");
  toast.setAttribute("role", "status");
  toast.setAttribute("aria-live", "polite");
  toast.className = "robot-toast";
  toast.innerHTML = `
    <div class="robot-toast__icon" aria-hidden="true">🤖</div>
    <div class="robot-toast__content">
      <div class="robot-toast__title">Mini robot</div>
      <p class="robot-toast__msg">${msg}</p>
    </div>
    <button class="robot-toast__close" type="button" aria-label="Cerrar mensaje">×</button>
  `;

  document.body.appendChild(toast);

  const style = document.createElement("style");
  style.textContent = `
    .robot-toast{
      position: fixed;
      right: 18px;
      bottom: 18px;
      z-index: 9999;

      display: grid;
      grid-template-columns: auto 1fr auto;
      gap: 10px;
      align-items: start;

      width: min(420px, calc(100% - 36px));
      padding: 14px 14px;

      background: rgba(255,255,255,0.92);
      border: 1px solid rgba(71,85,105,0.12);
      border-radius: 16px;
      box-shadow: 0 16px 50px rgba(15,23,42,0.18);

      backdrop-filter: blur(10px);

      transform: translateY(14px);
      opacity: 0;
      transition: opacity 180ms ease, transform 180ms ease;
    }
    .robot-toast.is-visible{
      transform: translateY(0);
      opacity: 1;
    }
    .robot-toast__icon{
      font-size: 22px;
      line-height: 1;
      margin-top: 2px;
    }
    .robot-toast__title{
      font-family: var(--ff-acento, system-ui);
      font-weight: 600;
      color: var(--c-azul-profundo-tec, #0F172A);
      margin-bottom: 4px;
    }
    .robot-toast__msg{
      margin: 0;
      color: var(--c-gris-prof, #475569);
      font-size: 0.95em;
      line-height: 1.45;
    }
    .robot-toast__close{
      appearance: none;
      border: 0;
      background: transparent;
      cursor: pointer;

      width: 34px;
      height: 34px;
      border-radius: 12px;

      font-size: 22px;
      line-height: 1;
      color: var(--c-gris-prof, #475569);

      transition: background-color 160ms ease, color 160ms ease;
    }
    .robot-toast__close:hover{
      background: rgba(10,102,194,0.10);
      color: var(--c-azul-clinico, #0A66C2);
    }
    .robot-toast__close:focus-visible{
      outline: none;
      box-shadow: 0 0 0 3px rgba(6,182,212,0.35);
    }
  `;
  document.head.appendChild(style);

  requestAnimationFrame(() => toast.classList.add("is-visible"));

  const closeBtn = toast.querySelector(".robot-toast__close");

  const dismiss = () => {
    toast.classList.remove("is-visible");

    // ✅ Ya NO guardamos nada en localStorage
    // localStorage.setItem(STORAGE_KEY, "1");

    window.setTimeout(() => {
      toast.remove();
      style.remove();
    }, 220);
  };

  closeBtn?.addEventListener("click", dismiss);

  window.addEventListener("keydown", (e) => {
    if (e.key === "Escape" && document.body.contains(toast)) dismiss();
  });
})();
